//////////////////////////////////////////////////////////////////////
////                                                              ////
//// registerInterface.v                                          ////
////                                                              ////
//// This file is part of the i2cSlave opencores effort.
//// <http://www.opencores.org/cores//>                           ////
////                                                              ////
//// Module Description:                                          ////
//// You will need to modify this file to implement your 
//// interface.
//// Add your control and status bytes/bits to module inputs and outputs,
//// and also to the I2C read and write process blocks  
////                                                              ////
//// To Do:                                                       ////
//// 
////                                                              ////
//// Author(s):                                                   ////
//// - Steve Fielding, sfielding@base2designs.com                 ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
////                                                              ////
//// Copyright (C) 2008 Steve Fielding and OPENCORES.ORG          ////
////                                                              ////
//// This source file may be used and distributed without         ////
//// restriction provided that this copyright statement is not    ////
//// removed from the file and that any derivative work contains  ////
//// the original copyright notice and the associated disclaimer. ////
////                                                              ////
//// This source file is free software; you can redistribute it   ////
//// and/or modify it under the terms of the GNU Lesser General   ////
//// Public License as published by the Free Software Foundation; ////
//// either version 2.1 of the License, or (at your option) any   ////
//// later version.                                               ////
////                                                              ////
//// This source is distributed in the hope that it will be       ////
//// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
//// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
//// PURPOSE. See the GNU Lesser General Public License for more  ////
//// details.                                                     ////
////                                                              ////
//// You should have received a copy of the GNU Lesser General    ////
//// Public License along with this source; if not, download it   ////
//// from <http://www.opencores.org/lgpl.shtml>                   ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
//
`include "i2cSlave_define.v"


module registerInterface (
  clk,
  addr,
  dataIn,
  writeEn,
  dataOut,
  reg0_auto_in,
  reg1_global_out,
  reg2_channel_upper_out,
  reg3_channel_lower_out,
  reg4_addrcntrl_out,
  reg5_wdata_lower_out,
  reg6_wdata_upper_out,
  reg9_control_source_out
);

input clk;
input [7:0] addr;
input [7:0] dataIn;
input writeEn;
output [7:0] dataOut;
input [7:0] reg0_auto_in;
output [7:0] reg1_global_out;
output [7:0] reg2_channel_upper_out;
output [7:0] reg3_channel_lower_out;
output [7:0] reg4_addrcntrl_out;
output [7:0] reg5_wdata_lower_out;
output [7:0] reg6_wdata_upper_out;
output [7:0] reg9_control_source_out;

reg [7:0] dataOut;
reg [7:0] reg_auto;
reg [7:0] reg_global;
reg [7:0] reg_channel_upper;
reg [7:0] reg_channel_lower;
reg [7:0] reg_addrcntrl;
reg [7:0] reg_wdata_lower;
reg [7:0] reg_wdata_upper;
reg [7:0] reg_control_source;


// --- I2C Read
always @(posedge clk) begin
  case (addr)
    8'h00: dataOut <= reg_auto;  
    8'h01: dataOut <= reg_global;  
    8'h02: dataOut <= reg_channel_upper;  
    8'h03: dataOut <= reg_channel_lower;
    8'h04: dataOut <= reg_addrcntrl;
    8'h05: dataOut <= reg_wdata_lower;
    8'h06: dataOut <= reg_wdata_upper;
    8'h09: dataOut <= reg_control_source;
    default: dataOut <= 8'h00;
  endcase
end


// --- I2C Write (or update from GPIO state)
always @(posedge clk) begin

	//I2C writeable registers
	if (writeEn == 1'b1)
		begin
		case (addr)
		8'h01: reg_global <= dataIn;
		8'h02: reg_channel_upper <= dataIn;
		8'h03: reg_channel_lower <= dataIn;
		8'h04: reg_addrcntrl <= dataIn;
		8'h05: reg_wdata_lower <= dataIn;
		8'h06: reg_wdata_upper <= dataIn;
		8'h09: reg_control_source <= dataIn;
		endcase
		end
	else
		begin
		if (reg_addrcntrl[5]) //clear the START bit if it is set
			begin
			reg_addrcntrl[5] <= 1'b0;
			end
		end
	  	
  	//update reg every cycle
	reg_auto <= reg0_auto_in;
   
end


// --- Assign outputs from registers
assign reg1_global_out = reg_global;
assign reg2_channel_upper_out = reg_channel_upper;
assign reg3_channel_lower_out = reg_channel_lower;
assign reg4_addrcntrl_out = reg_addrcntrl;
assign reg5_wdata_lower_out = reg_wdata_lower;
assign reg6_wdata_upper_out = reg_wdata_upper;
assign reg9_control_source_out = reg_control_source;

endmodule


 
